asm(".include \"calcinfo.s\"");

#include "tiams.h"
#include "OurWorld.h"
#include "OurWorldr1.h"

#define VERSION		"1.0"
#define DATE		"8/13"
#define YEAR		"2003"

asm(".extern DrawGlobe");
asm(".global _LabelData");
asm(".global _Sprite_Widths");
asm(".global _ngrams");

static void AP_app(pFrame self, PEvent e);
FRAME(appObj, OO_SYSTEM_FRAME, 0, OO_APP_FLAGS, 5)
   ATTR(OO_APP_FLAGS, APP_INTERACTIVE)
   ATTR(OO_APP_NAME, "Our World")
   ATTR(OO_APP_PROCESS_EVENT, &AP_app)
   ATTR(OO_APP_DEFAULT_MENU, NULL )
   ATTR(OO_APP_ICON, &AppIcon )
ENDFRAME

pFrame pAppObj = (pFrame)&appObj;  /* Must be 1st! */
BYTE oldfolder[SYM_LEN+1];   
unsigned char *pBmp;
short curX = 0, curY = 0;
short curYCos = 32767, curYSin = 0;
short zoom = 0;
short zoomZ, zoomSkip;
char DialogBuffer[192];

unsigned char optionLabels = 0;
unsigned char optionClutter = 0;
unsigned char zoomLevel;

static void AP_app(pFrame self, PEvent e)
{
   Access_AMS_Global_Variables;
   short key;
   WORD opts[2];

   switch (e->command)
   {
   case CM_START:
      MO_currentOptions();
      MO_option[MO_OPT_SPLIT_SCREEN] = D_MODE_SPLIT_FULL;
      if (MO_option[MO_OPT_SPLIT_1] != EV_runningApp)
      {
         MO_option[MO_OPT_SPLIT_1] = EV_runningApp;
         EV_appB = EV_appA;
      }
      MO_digestOptions(H_NULL);
      if (!zoom)
      {      
         zoom = Zooms[zoomLevel = 0];
         goto help;
      }
      break;
      
   case CM_ACTIVATE:
      FolderGetCur(oldfolder);
      ST_folder("F1-MENU");
      PaintScreen();
      break;
      
   case CM_DEACTIVATE:
      ST_helpMsg(NULL);
      ST_folder((char *)oldfolder);
      break;
      
   case CM_KEY_PRESS:
      key = e->info.keyInfo.keyCode;
      switch (key)
      {
      case KB_F1:
      case KB_ESC:
         switch(MenuPopup(&AppMenu, -1, -1, 0))
         {
         case ACM_HELP:
help:
            DlgNotice("HELP", "Use arrow keys to pan.\nUse + and - to zoom.\nPress F1 for more functions.");
            break;
         case ACM_OPTIONS:
            goto options;
         case ACM_SENSOR:
            goto sensor;
         case ACM_DISTANCE:
            goto distance;
         case ACM_ABOUT:
            DlgNotice("ABOUT", "Our World - Virtual Atlas\nVersion " VERSION ", " DATE "/" YEAR "\nwritten by Kirk Meyer");
            break;
         case ACM_EXIT:
            EV_quit();
            break;
         case ACM_SEARCH:
            goto find;
         }
         break;
         
      case KB_F2:
options:
         opts[0] = (optionLabels >> 6) + 1;
         opts[1] = optionClutter + 1;
         if (Dialog(&OptionsDialog, -1, -1, NULL, opts) == KB_ENTER)
         {
            optionLabels = (opts[0] - 1) << 6;
            optionClutter = opts[1] - 1;
            PaintScreen();
         }
         break;
         
      case KB_F3:
sensor:         
      {
         char message[64], a = 'S', b = 'E';
         int x, y;
         x = (int)(((long)curX * 675) >> 11);
         y = (int)(((long)curY * 675) >> 11);
         if (x < 0)
         {
            b = 'W';
            x = -x;
         }
         if (y < 0)
         {
            a = 'N';
            y = -y;
         }
         
         sprintf(message,
#if defined(_92)
         " Latitude: %d%d'%c\nLongitude: %d%d'%c"
#else
         "Latitude: %d%d'%c\nLongitude: %d%d'%c"
#endif
            , y / 60, y % 60, a, x / 60, x % 60, b);
         DlgNotice("SENSOR", message);
         break;
      }
      
      case KB_F4:
distance:
      {
         int savex, savey, x1, y1, x2, y2;
         double lat1, lon1, lat2, lon2;
         double F, G, lambda, omega, S, C, R;
         double mi, km;
         char buf[64];
         
         savex = curX;
         savey = curY;
         
         if (Dialog(&DistanceDialog, -1, -1, DialogBuffer, NULL) == KB_ENTER)
         {
            if (FindLabel(DialogBuffer + 64, "CITY 1"))
            {
               x1 = curX;
               y1 = curY;
               curX = savex;
               curY = savey;
               if (FindLabel(DialogBuffer + 128, "CITY 2"))
               {
                  x2 = curX;
                  y2 = curY;
                  curX = savex;
                  curY = savey;
                  
                  lat1 = ((double)y1) * FLOATTAB[FPI_ONEPI] / FLOATTAB[FPI_32767];
                  lat2 = ((double)y2) * FLOATTAB[FPI_ONEPI] / FLOATTAB[FPI_32767];
                  lon1 = ((double)x1) * FLOATTAB[FPI_ONEPI] / FLOATTAB[FPI_32767];
                  lon2 = ((double)x2) * FLOATTAB[FPI_ONEPI] / FLOATTAB[FPI_32767];
                  
#define EARTH_RADIUS 6378.14
#define KM_TO_MI 0.62137
#define SQUASH_FACTOR (1.0/298.257)
                  F = (lat1 + lat2) / 2.0;
                  G = (lat1 - lat2) / 2.0;
                  lambda = (lon1 - lon2) / 2.0;

                  S = pow(sin(G) * cos(lambda), 2.0) + pow(cos(F) * sin(lambda), 2.0);
                  C = pow(cos(G) * cos(lambda), 2.0) + pow(sin(F) * sin(lambda), 2.0);          
                  omega = atan(sqrt(S / C));
                  
                  R = sqrt(S * C) / omega;
                  
                  km = 2.0 * omega * EARTH_RADIUS * (1.0 + SQUASH_FACTOR * ((3.0 * R - 1.0) / 2.0 / C) * pow(sin(F) * cos(G), 2.0) - SQUASH_FACTOR * ((3.0 * R + 1.0) / 2.0 / S) * pow(cos(F) * sin(G), 2.0));
                  mi = km * KM_TO_MI;
                  
                  sprintf (buf,
#if defined(_92)
"The surface distance is:\n%5.0f miles\n%5.0f kilometers"
#else
"The surface distance is:\n%.0f miles\n%.0f kilometers"
#endif
                  , mi, km);
                  DlgNotice ("DISTANCE", buf);
               }
            }
         }

         break;
      }
         
      case KB_F5:
find:
         opts[0] = opts[1] = 1;
         if (Dialog(&FindDialog, -1, -1, DialogBuffer, NULL) == KB_ENTER)
            if (FindLabel(DialogBuffer, "FIND"))
               PaintScreen();
         break;
         	
      case KB_LEFT:
      	 curX -= 16384 / zoom;
         PaintScreen();
         break;
      case KB_RIGHT:
      	 curX += 16384 / zoom;
         PaintScreen();
         break;
      case KB_UP:
         if (curY > -16384)
         {
            curY -= 16384 / zoom;
            if (curY < -16384)
               curY = -16384; 
            PaintScreen();
         }
         break;
      case KB_DOWN:
         if (curY < 16384)
         {
            curY += 16384 / zoom;
            if (curY > 16384)
               curY = 16384; 
            PaintScreen();
         }
         break;
      case '+':
      	 if (zoomLevel < MAX_ZOOM)
      	 {
      	    zoom = Zooms[++zoomLevel];
      	    PaintScreen();      	    
      	 }
      	 break;
      case '-':
         if (zoomLevel)
         {
            zoom = Zooms[--zoomLevel];      	    
    	    PaintScreen();
    	 }
      	 break;
         
      case KB_OFF:
      case KB_ON + KB_OPTION:
      case KB_MENU:
      case KB_MENU + KB_OPTION:
      case KB_QUIT:
      case KB_SWITCH:
      case KB_HOME:
#if defined(_89)
      case KB_HOME + KB_OPTION:
#endif
      case KB_YEQ:
      case KB_RANGE:
      case KB_GRAPH:
      case KB_TBLSET:
      case KB_TABLE:
         EV_defaultHandler(e);
         break;
      }
      break;
        
   default:
      EV_defaultHandler(e);
      break;
   }
}

static void PaintScreen(void)
{
   int i;
   unsigned char screen[CBMP + 128 + 2];
   
   pBmp = screen + 128 + 2 + (32 * 6);

   asm(" move.l _pBmp.l,a0");
   asm(" moveq #(CY-1),d0");
   asm(" clr.l d1");
   asm("ClearLoop:");
   asm(" move.l d1,(a0)+");
   asm(" move.l d1,(a0)+");
   asm(" move.l d1,(a0)+");
   asm(" move.l d1,(a0)+");
   asm(" move.l d1,(a0)+");
#if defined(_92)
   asm(" move.l d1,(a0)+");
   asm(" move.l d1,(a0)+");
   asm(" move.l d1,(a0)+");
#else
   asm(" lea 12(a0),a0");
#endif
   asm(" dbf d0,ClearLoop");
   
   zoomZ = zoom * CZ;
#if defined(_89)
   zoomSkip = (1 + (80 / zoom)) << 1;
   zoomLevel--;
#else
   zoomSkip = (1 + (64 / zoom)) << 1;
#endif
   zoomLevel -= optionClutter;
   
   asm (" jsr DrawGlobe");
   
   zoomLevel += optionClutter;
#if defined(_89)
   zoomLevel++;
#endif

   asm(" move.l _pBmp.l,a0");
   asm(" lea 0x4C00,a1");
   
   asm(" clr.l d1");
   asm(" subq.l #1,d1");
   asm(" move.l d1,(a1)+");
   asm(" move.l d1,(a1)+");
   asm(" move.l d1,(a1)+");
   asm(" move.l d1,(a1)+");
   asm(" move.l d1,(a1)+");
#if defined(_92)
   asm(" move.l d1,(a1)+");
   asm(" move.l d1,(a1)+");
   asm(" move.w d1,(a1)+");
#else
   asm(" lea 10(a1),a1");
#endif

   asm(" moveq #(CY-1),d0");
   asm("CopyLoop:");
   asm(" bset.b #7,(a0)");
#if defined(_92)
   asm(" bset.b #0,29(a0)");
#else
   asm(" bset.b #0,19(a0)");
#endif
   asm(" move.l (a0)+,(a1)+");
   asm(" move.l (a0)+,(a1)+");
   asm(" move.l (a0)+,(a1)+");
   asm(" move.l (a0)+,(a1)+");
   asm(" move.l (a0)+,(a1)+");
#if defined(_92)
   asm(" move.l (a0)+,(a1)+");
   asm(" move.l (a0)+,(a1)+");
   asm(" move.w (a0)+,(a1)+");
   asm(" addq.l #2,a0");
#else
   asm(" lea 12(a0),a0");
   asm(" lea 10(a1),a1");
#endif
   asm(" dbf d0,CopyLoop");
}

static short FindLabel(char *DialogBuffer, char *title)
{
   Access_AMS_Global_Variables;
   
   const unsigned char *p;
   char region[64];
   char buffer[64];
   HANDLE hPopup;
   int i, l;
   unsigned char j, k;
   
   for (l = 0; DialogBuffer[l]; l++)
   {
      DialogBuffer[l] = toupper(DialogBuffer[l]);
   }
   if (l < 2)
   {
      DlgNotice("", "You must enter at least two letters of the feature name.");
      return 0;
   }
   hPopup = PopupNew(title, 0);
   i = 0;
   
   for (p = LabelData; *p; )
   {
      j  = (*p++) & 31;
      k  =  *p++;
      p += 4;
      p = NameCopy(buffer, p, j);
      if (k & 0x80)
      {
         strcpy(region, buffer);
         if (title[0] == 'C')
            continue;
      }
      else
      {
         strcat(buffer, ", ");
         strcat(buffer, region);
      }
      if (!strncmp(buffer, DialogBuffer, l))
         PopupAddText(hPopup, -1, buffer, ++i);
   }
   
   if (!i)
   {
      DlgNotice("", "Feature not found.");
      PopupFree(hPopup);
      return 0;
   }   
   
   if (i > 1)
   {
      if (!(i = PopupDo(hPopup, -1, -1, 0)))
      {
         PopupFree(hPopup);
         return 0;
      }
   }
      
   for (p = LabelData; *p; )
   {
      j  = (*p++) & 31;
      k  =  *p++;
      curX  = (*p++) << 8;
      curX += (*p++);
      curY  = (*p++) << 8;
      curY += (*p++);
      p = NameCopy(buffer, p, j);
      if (k & 0x80)    
      {
         strcpy(region, buffer);
         if (title[0] == 'C')
            continue;
      }
      else
      {
         strcat(buffer, ", ");
         strcat(buffer, region);
      }
      
      if (!strncmp(buffer, DialogBuffer, l))
      {
         if (!(--i))
         {
            strcpy(DialogBuffer, buffer);
            goto done;
         }
      }
   }
         
done:
   curY = -curY;
   
   if (title[0] != 'C')
   {
      zoomLevel = k & 31;
      if (zoomLevel == 31)
         zoomLevel = 5;
      zoomLevel += optionClutter;
#if defined(_89)
      zoomLevel++;
#endif
      zoom = Zooms[zoomLevel];
   }
   PopupFree(hPopup);
   
   return 1;
}

static const unsigned char *NameCopy(char *buffer, const unsigned char *p, unsigned char j)
{
   unsigned char c;
   
   for ( ; j; j--)
   {      
      c = *p++;
      if (c >= 32 && c < 96)
      {
         *buffer++ = c;
      }
      else
      {
         c -= 96;
         *buffer++ = ngrams[c][0];
         *buffer++ = ngrams[c][1];
      }
   }
   *buffer = 0;
   
   return p;
}
