.opt proc=68000
.include "calcinfo.s"

.global DrawGlobe

.extern _LabelData
.extern _Sprite_Widths
.extern _ngrams

DrawGlobe:
	movem.l	d0-d7/a0-a5,-(sp)
	subq.l	#6,sp
	subq.l	#8,sp
	
	move.w	_zoomSkip.l,8(sp)
	
	move.l	_pBmp.l,a2
	lea		_TrigTable,a3
	lea		_MapData,a4

	move.w	_curY.l,d0	
	move.w	d0,d7
	clr.b		d7
	lsr.w		#7,d7
	movem.w	0(a3,d7.w),d2-d3
	sub.w		d2,d3
	move.w	d0,d4
	and.w		#$00FF,d4
	muls		d3,d4
	asr.l		#8,d4
	add.w		d2,d4	
	addi.w	#$4000,d0	
	move.w	d0,d7
	clr.b		d7
	lsr.w		#7,d7
	movem.w	0(a3,d7.w),d2-d3
	sub.w		d2,d3
	move.w	d0,d5
	and.w		#$00FF,d5
	muls		d3,d5
	asr.l		#8,d5
	add.w		d2,d5
	move.w	d4,_curYSin.l
	move.w	d5,_curYCos.l

PolylineLoop:
	clr.w		d0
	move.b	(a4)+,d0
	addq.w	#7,d0
	add.w		d0,d0
	movea.l	a4,a5
	adda.w	d0,a5
	
	move.b	(a4)+,d0
	lsl.w		#8,d0
	move.b	(a4)+,d0	
	move.b	(a4)+,d1
	lsl.w		#8,d1
	move.b	(a4)+,d1
	bsr		XYtoXYZ
	bsr		XYZtoXYNoClip
	cmpi.b	#1,d4
	beq		ClipSkip
	move.l	d4,10(sp)
	
	move.b	(a4)+,d0
	lsl.w		#8,d0
	move.b	(a4)+,d0
	move.b	(a4)+,d1
	lsl.w		#8,d1
	move.b	(a4)+,d1	
	bsr		XYtoXYZ
	bsr		XYZtoXYNoClip
	cmpi.b	#1,d4
	beq		ClipSkip
	and.l		10(sp),d4
	beq		ClipOkay

ClipSkip:
	movea.l	a5,a4
	bra		PolylineSkip
	
ClipOkay:	
	move.b	(a4)+,d0
	lsl.w		#8,d0
	move.b	(a4)+,d0
	move.b	(a4)+,d1
	lsl.w		#8,d1
	move.b	(a4)+,d1
	movem.w	d0-d1,(sp)

	bsr		XYtoXYZ
	bsr		XYZtoXY
	movem.w	d0-d1,4(sp)
	move.l	d4,10(sp)
	
	movea.l	a4,a1
	adda.w	8(sp),a1
LineLoop:
	cmpa.l	a5,a4
	bge		PolylineDone
LineLoopChecked:	
	movem.w	(sp),d0-d1
	move.b	(a4)+,d2
	ext.w		d2
	move.b	(a4)+,d3
	ext.w		d3
	add.w		d2,d0
	add.w		d3,d1
	movem.w	d0-d1,(sp)
	
	cmpa.l	a1,a4
	bne		LineLoop

	movea.l	a4,a1
	adda.w	8(sp),a1
	
	bsr		DrawLine
	cmpa.l	a5,a4
	blt		LineLoopChecked
	bra		PolylineSkip	
	
PolylineDone:
	movem.w	(sp),d0-d1
	bsr		DrawLine
PolylineSkip:
	cmpa.l	a3,a4
	blt		PolylineLoop

	addq.l	#8,sp
	addq.l	#6,sp

;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;; DrawLabels
	lea		_LabelData,a4

LabelsLoop:
	moveq.l	#31,d4
	move.b	(a4)+,d2
	and.w		d4,d2
	beq		LabelsDone
	movea.l	a4,a1
	lea		5(a4,d2.w),a4
	move.b	(a1)+,d3
	cmp.b		(_optionLabels.l),d3
	bcs		LabelsLoop
	and.b		d4,d3
	cmp.b		_zoomLevel.l,d3
	bgt		LabelsLoop
	
	move.b	(a1)+,d0	
	lsl.w		#8,d0
	move.b	(a1)+,d0
	move.b	(a1)+,d1
	lsl.w		#8,d1
	move.b	(a1)+,d1
	
	bsr		XYtoXYZ
	bsr		XYZtoXYNoClip
	tst.l		d4
	bne		LabelsLoop
	
	subq.w	#3,d0
	subq.w	#3,d1
	
	clr.l		d2
	move.b	-6(a1),d2
	move.b	-5(a1),d3
	lsr.b		#5,d2
	cmpi.b	#4,d2
	blt		LabelNoFix
	addq.l	#1,d2
LabelNoFix:
	add.b		d3,d3
	bcs		LabelCountry
	lea		Sprite_City,a0
	add.b		d3,d3
	bcc		LabelMarker
	lea		Sprite_Capital,a0
LabelMarker:
	bsr		DrawSprite	
	bra		LabelReady	
LabelCountry:
	add.b		d3,d3
	bcs		LabelReady
	moveq.l	#4,d2
LabelReady:

	addq.w	#1,d0
	addq.w	#1,d1

	lea		-322(a2),a0
	lea		_Sprite_Widths,a5
	clr.w		d4
	moveq.l	#7,d5
GetLabelName:
	move.b	(a1)+,d4
	move.w	d4,d7
	subi.b	#96,d7
	beq		GetLabelDone
	cmpi.b	#192,d7
	bcs		GetLabelCompressed
	bsr		ConvertChar
	bra		GetLabelCont
GetLabelCompressed:	
	add.w		d7,d7
	move.b	33(a5,d7.w),d4
	bsr		ConvertChar
	move.b	d4,(a0)+
	move.b	(a5,d4.w),(a0)+
	move.b	34(a5,d7.w),d4
	bsr		ConvertChar
GetLabelCont:
	move.b	d4,(a0)+
	move.b	(a5,d4.w),(a0)+
	cmpa.l	a1,a4
	bgt		GetLabelName
GetLabelDone:
	move.b	#0x1F,(a0)+
	clr.b		(a0)
	
	or.b		d3,d3
	bpl		GetLabelNoSwap
	exg		d0,d1
	neg.w		d1
GetLabelNoSwap:
	subq.b	#3,d2
	bcc		GetLabelNotTop
	sub.w		d5,d1	
	bra		GetLabelNotBottom	
GetLabelNotTop:
	subq.b	#3,d2
	bcc		GetLabelNotMiddle
	asr.w		#1,d5
	addq.w	#2,d1
	sub.w		d5,d1	
	bra		GetLabelNotBottom	
GetLabelNotMiddle:
	subq.b	#3,d2
	addq.w	#5,d1
GetLabelNotBottom:
	subq.w	#6,d1

	or.b		d3,d3
	bpl		GetLabelNoNeg
	neg.w		d1
	subq.w	#3,d1
GetLabelNoNeg:

	lea		-323(a2),a1
	move.w	d0,d4	
PutCharNewLine:
	addq.w	#6,d1
	or.b		d3,d3
	bpl		PutCharNewLineOkay
	subq.w	#6,d1
	subq.w	#6,d1
PutCharNewLineOkay:
	addq.l	#1,a1
	move.w	d4,d0
	clr.w		d7

	cmpi.b	#-1,d2
	beq		PutCharLeft
	
	lea		1(a1),a0
	clr.w		d0
PutCharGetWidth:	
	move.b	(a0)+,d7
	add.w		d7,d0
	addq.l	#1,a0
	tst.b		d7
	bne		PutCharGetWidth
	cmpi.b	#-3,d2
	beq		PutCharRight
	asr.w		#1,d0
	subq.w	#2,d0
PutCharRight:	
	neg.w		d0
	add.w		d4,d0
	bra		PutChar	
PutCharLeft:
	addq.w	#5,d0

PutChar:
	move.b	(a1)+,d7
	cmpi.b	#0x1F,d7
	beq		LabelsLoop
	bcc		PutCharNewLine
	move.w	d7,d6
	lsl.w		#4,d7
	sub.w		d6,d7
	sub.w		d6,d7
	or.b		d3,d3
	bpl		PutCharHoriz

	lea		Sprite_Vert,a0
	adda.w	d7,a0
	exg		d0,d1
	bsr		DrawSprite
	exg		d0,d1
	bra		PutCharVert
PutCharHoriz:
	lea		Sprite_Horiz,a0
	adda.w	d7,a0
	bsr		DrawSprite	
PutCharVert:

	clr.w		d7
	move.b	(a1)+,d7
	add.w		d7,d0
	bra		PutChar

LabelsDone:
	movem.l	(sp)+,d0-d7/a0-a5
	rts
	
;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;
	
XYtoXYZ:
	sub.w		_curX.l,d0
	move.w	d0,d7
	clr.b		d7
	lsr.w		#7,d7
	movem.w	0(a3,d7.w),d2-d3
	sub.w		d2,d3
	move.w	d0,d4
	and.w		#$00FF,d4
	muls		d3,d4
	asr.l		#8,d4
	add.w		d2,d4
	
	addi.w	#$4000,d0
	move.w	d0,d7
	clr.b		d7
	lsr.w		#7,d7
	movem.w	0(a3,d7.w),d2-d3
	sub.w		d2,d3
	move.w	d0,d5
	and.w		#$00FF,d5
	muls		d3,d5
	asr.l		#8,d5
	add.w		d2,d5
	
	move.w	d1,d7
	clr.b		d7
	lsr.w		#7,d7
	movem.w	0(a3,d7.w),d2-d3
	sub.w		d2,d3
	move.w	d1,d6
	and.w		#$00FF,d6
	muls		d3,d6
	asr.l		#8,d6
	add.w		d2,d6
	
	addi.w	#$4000,d1
	move.w	d1,d7
	clr.b		d7
	lsr.w		#7,d7
	movem.w	0(a3,d7.w),d2-d3
	sub.w		d2,d3
	move.w	d1,d7
	and.w		#$00FF,d7
	muls		d3,d7
	asr.l		#8,d7
	add.w		d2,d7
	
	; d4 = sin(x) ; d5 = cos(x) ; d6 = sin(y) ; d7 = cos(y)
	
	move.w	d4,d0
	muls		d7,d0
	add.l		d0,d0
	swap		d0
	
	muls		d5,d7
	add.l		d7,d7
	swap		d7
	
	; d0 = x' ; d6 = y' ; d7 = z'
	
	move.w	_curYCos.l,d4
	move.w	_curYSin.l,d5
	
	move.w	d6,d1
	muls		d4,d1
	add.l		d1,d1
	swap		d1
	move.w	d7,d2
	muls		d5,d2
	add.l		d2,d2
	swap		d2
	add.w		d2,d1
	
	;d0 = x, d1 = y, d2 is ready to be z if necessary
	rts

XYZtoXYNoClip:
	move.w	d7,d2
	muls		d4,d2
	add.l		d2,d2
	swap		d2
	move.w	d6,d3
	muls		d5,d3
	add.l		d3,d3
	swap		d3
	sub.w		d3,d2
	bmi		XYZBad
	
XYZtoXY:
	move.w	_zoomZ.l,d3

	muls		d3,d0
	swap		d0
	addi.w	#(CX/2),d0
	
	neg.w 	d1
	muls		d3,d1
	swap		d1
	addi.w	#(CY/2)+1,d1
	
GetCSCode:		; Get the Cohen-Sutherland clipping algorithm code for (D0,D1) into D3
	or.w		d1,d1
	smi		d4
	lsl.w		#8,d4
	cmpi.w	#CY,d1
	sge		d4
	swap		d4
	or.w		d0,d0
	smi		d4
	lsl.w		#8,d4
	cmpi.w	#CX,d0
	sge		d4
	rts
	
XYZBad:
	moveq		#1,d4
	rts

DrawLine:
	bsr		XYtoXYZ
	bsr		XYZtoXYNoClip
	move.l	14(sp),d5		; was 10(sp)
	move.l	d4,14(sp)
	movem.w	8(sp),d2-d3		; was 4(sp)
	movem.w	d0-d1,8(sp)
	;cmpi.b	#1,d4
	;beq		DrawLineDone
	;cmpi.b	#1,d5
	;beq		DrawLineDone
	
;This is the Cohen-Sutherland line clipping algorithm. First, we try to trivially reject.
CohenSutherland:
	move.l	d4,d6
	and.l		d5,d6
	bne		DrawLineDone
	
	or.l		d4,d4
	bne		CohenNoSwitch
	or.l		d5,d5
	beq		DrawLineOkay
	exg		d0,d2
	exg		d1,d3
	exg		d4,d5
CohenNoSwitch:
	
	or.b		d4,d4
	beq		CohenNotRight	
	move.w	d3,d6
	sub.w		d1,d6
	move.w	d0,d7
	subi.w	#CX-1,d7	
	muls		d7,d6
	sub.w		d2,d0
	beq		DrawLineDone
	divs		d0,d6
	add.w		d6,d1
	move.w	#CX-1,d0
	bsr		GetCSCode
	bra		CohenSutherland	
CohenNotRight:

	add.w		d4,d4
	bcc		CohenNotLeft	
	move.w	d3,d6
	sub.w		d1,d6
	muls		d0,d6
	sub.w		d2,d0
	beq		DrawLineDone
	divs		d0,d6
	add.w		d6,d1
	clr.w		d0
	bsr		GetCSCode
	bra		CohenSutherland	
CohenNotLeft:

	add.l		d4,d4
	bcc		CohenNotTop
	move.w	d2,d6
	sub.w		d0,d6
	muls		d1,d6
	sub.w		d3,d1
	beq		DrawLineDone
	divs		d1,d6
	add.w		d6,d0
	clr.w		d1
	bsr		GetCSCode
	bra		CohenSutherland	
CohenNotTop:

	move.w	d2,d6
	sub.w		d0,d6
	move.w	d1,d7
	subi.w	#CY-1,d7
	muls		d7,d6
	sub.w		d3,d1
	beq		DrawLineDone
	divs		d1,d6
	add.w		d6,d0
	move.w	#CY-1,d1
	bsr		GetCSCode
	bra		CohenSutherland
		
DrawLineOkay:
	movea.l	a2,a0
	cmp.w		d0,d2
	bcc		DXpos
	exg		d0,d2
	exg		d1,d3
DXpos:
	move.w	d1,d4
	lsl.w		#5,d4
	move.w	d0,d5
	lsr.w		#3,d5
	add.w		d5,d4
	move.w	d0,d5
	not.w		d5
	and.b		#$07,d5
	adda.w	d4,a0
	bset.b	d5,(a0)
	move.b	d5,d6
	moveq		#1,d5
	lsl		d6,d5
	move.w	d2,d6
	sub.w		d0,d6
ChY:
	cmp.w		d1,d3
	bcc		DYpos
	moveq		#-32,d4
	move.w	d1,d7
	sub.w		d3,d7
	bra		PutP1
DYpos:
	moveq		#32,d4
	move.w	d3,d7
	sub.w		d1,d7
PutP1:
	cmp.w		d0,d2
	bne		DotsNE
	cmp.w		d1,d3
	beq		DrawLineDone
DotsNE:
	cmp.w		d6,d7
	bcc		DY_Greater
	move.l	d6,d2
	subq		#1,d2
	move.w	d7,d3
	sub.w		d6,d3
	asl.w		#1,d3
	lsl.w		#1,d7
	sub.w		d7,d6
	neg		d6
RepX:
	or.w		d6,d6
	bmi		X_DNeg
	adda		d4,a0
	add.w		d3,d6
	bra		IncX
X_DNeg:
	add.w		d7,d6
IncX:
	ror.b		#1,d5
	bcc		X_SameByte
	addq		#1,a0
X_SameByte:
	or.b		d5,(a0)
	dbra		d2,RepX
	bra		DrawLineDone
DY_Greater:
	move.l	d7,d3
	subq		#1,d3
	move.w	d6,d2
	sub.w		d7,d2
	lsl.w		#1,d2
	lsl.w		#1,d6
	sub.w		d6,d7
	neg		d7
RepY:
	or.w		d7,d7
	bmi		Y_DNeg
	ror.b		#1,d5
	bcc		Y_SameByte
	addq		#1,a0
Y_SameByte:
	add.w		d2,d7
	bra		IncY
Y_DNeg:
	add.w		d6,d7
IncY:
	adda		d4,a0
	or.b		d5,(a0)
	dbra		d3,RepY
DrawLineDone:
	rts

;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;
;inputs: A0 -> sprite, A2 -> bitmap, drawn at (D0, D1)
DrawSprite:
	cmpi.w	#-6,d0
	ble		DrawSpriteDone
	cmpi.w	#(CX-1),d0
	bge		DrawSpriteDone
	cmpi.w	#-6,d1
	ble		DrawSpriteDone
	cmpi.w	#(CY-1),d1
	bge		DrawSpriteDone
	
	move.w	d1,d7
	lsl.w		#5,d7
	move.w	d0,d6
	asr.w		#4,d6
	add.w		d6,d6
	add.w		d7,d6	
	movea.l	a2,a5
	ext.l		d6	
	adda.l	d6,a5
	move.b	d0,d7	
	moveq.l	#24,d6
	andi.b	#15,d7
	sub.w		d7,d6
	
	moveq.l	#6,d7		; 7 - 1
DrawSpriteLoop:
	clr.l		d5
	move.b	(a0)+,d5
	lsl.l		d6,d5
	not.l		d5
	and.l		d5,(a5)
	clr.l		d5
	move.b	(a0)+,d5
	lsl.l		d6,d5
	or.l		d5,(a5)
	lea		32(a5),a5
	dbra		d7,DrawSpriteLoop	
DrawSpriteDone:
	rts
;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;

ConvertChar:
	cmpi.b	#0x20,d4
	bne		ConvertCharNotSpace
	addq.w	#6,d5
	bra		ConvertCharDone
ConvertCharNotSpace:
	subi.b	#0x27,d4
	beq		ConvertCharDone
	subq.l	#5,d4
	cmpi.b	#3,d4
	blt		ConvertCharDone
	subi.b	#0x12,d4
ConvertCharDone:
	rts
	
.include "sprites.inc"
